/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.StainedGlassBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.level.block.state.BlockState;

public class SpawnUtil {
    public static <T extends Mob> Optional<T> trySpawnMob(EntityType<T> p_216404_, MobSpawnType p_216405_, ServerLevel p_216406_, BlockPos p_216407_, int p_216408_, int p_216409_, int p_216410_, Strategy p_216411_) {
        BlockPos.MutableBlockPos $$8 = p_216407_.mutable();
        for (int $$9 = 0; $$9 < p_216408_; ++$$9) {
            Mob $$12;
            int $$10 = Mth.randomBetweenInclusive(p_216406_.random, -p_216409_, p_216409_);
            int $$11 = Mth.randomBetweenInclusive(p_216406_.random, -p_216409_, p_216409_);
            $$8.setWithOffset(p_216407_, $$10, p_216410_, $$11);
            if (!p_216406_.getWorldBorder().isWithinBounds($$8) || !SpawnUtil.moveToPossibleSpawnPosition(p_216406_, p_216410_, $$8, p_216411_) || ($$12 = (Mob)p_216404_.create(p_216406_, null, $$8, p_216405_, false, false)) == null) continue;
            if ($$12.checkSpawnRules(p_216406_, p_216405_) && $$12.checkSpawnObstruction(p_216406_)) {
                p_216406_.addFreshEntityWithPassengers($$12);
                return Optional.of($$12);
            }
            $$12.discard();
        }
        return Optional.empty();
    }

    private static boolean moveToPossibleSpawnPosition(ServerLevel p_216399_, int p_216400_, BlockPos.MutableBlockPos p_216401_, Strategy p_216402_) {
        BlockPos.MutableBlockPos $$4 = new BlockPos.MutableBlockPos().set(p_216401_);
        BlockState $$5 = p_216399_.getBlockState($$4);
        for (int $$6 = p_216400_; $$6 >= -p_216400_; --$$6) {
            p_216401_.move(Direction.DOWN);
            $$4.setWithOffset((Vec3i)p_216401_, Direction.UP);
            BlockState $$7 = p_216399_.getBlockState(p_216401_);
            if (p_216402_.canSpawnOn(p_216399_, p_216401_, $$7, $$4, $$5)) {
                p_216401_.move(Direction.UP);
                return true;
            }
            $$5 = $$7;
        }
        return false;
    }

    public static interface Strategy {
        @Deprecated
        public static final Strategy LEGACY_IRON_GOLEM = (p_289751_, p_289752_, p_289753_, p_289754_, p_289755_) -> {
            if (p_289753_.is(Blocks.COBWEB) || p_289753_.is(Blocks.CACTUS) || p_289753_.is(Blocks.GLASS_PANE) || p_289753_.getBlock() instanceof StainedGlassPaneBlock || p_289753_.getBlock() instanceof StainedGlassBlock || p_289753_.getBlock() instanceof LeavesBlock || p_289753_.is(Blocks.CONDUIT) || p_289753_.is(Blocks.ICE) || p_289753_.is(Blocks.TNT) || p_289753_.is(Blocks.GLOWSTONE) || p_289753_.is(Blocks.BEACON) || p_289753_.is(Blocks.SEA_LANTERN) || p_289753_.is(Blocks.FROSTED_ICE) || p_289753_.is(Blocks.TINTED_GLASS) || p_289753_.is(Blocks.GLASS)) {
                return false;
            }
            return !(!p_289755_.isAir() && !p_289755_.liquid() || !p_289753_.isSolid() && !p_289753_.is(Blocks.POWDER_SNOW));
        };
        public static final Strategy ON_TOP_OF_COLLIDER = (p_216416_, p_216417_, p_216418_, p_216419_, p_216420_) -> p_216420_.getCollisionShape(p_216416_, p_216419_).isEmpty() && Block.isFaceFull(p_216418_.getCollisionShape(p_216416_, p_216417_), Direction.UP);

        public boolean canSpawnOn(ServerLevel var1, BlockPos var2, BlockState var3, BlockPos var4, BlockState var5);
    }
}

